//
//	>>> Spiral Generator by JAC! <<<
//
//	Created for Sillyventure 2013 in Gdansk.

package com.wudsn.productions.atari800.rebbstars;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

import javax.swing.JApplet;

@SuppressWarnings("serial")
public class SpiralGenerator extends JApplet {

    static final int XSIZE = 24;
    static final int YSIZE = 14;
    static final int ZOOM = 32;

    private BufferedImage bi;

    @Override
    public void init() {

	setSize(XSIZE * ZOOM  + 32, YSIZE * ZOOM + 32);
	bi = new BufferedImage(XSIZE * 2, YSIZE, BufferedImage.TYPE_INT_RGB);
	test(bi);
    }

    @Override
    public void paint(Graphics g) {
	Graphics2D g2d = (Graphics2D) g;
	AffineTransform tx = new AffineTransform();
	tx.setToScale(ZOOM, ZOOM);
	g2d.drawImage(bi, tx, this);
    }

    private void printArray(String name, List<Integer> array) {
	if (name == null) {
	    throw new IllegalArgumentException("Parameter 'name' must not be null.");
	}
	if (array == null) {
	    throw new IllegalArgumentException("Parameter 'array' must not be null.");
	}
	System.out.print(name + "\t" + ".byte ");
	for (int i = 0; i < array.size(); i++) {
	    System.out.print(array.get(i));
	    if (i < array.size() - 1) {
		System.out.print(",");
	    }
	}
	System.out.println();
    }

    private void printArrayHex(String name, List<Integer> array) {
	if (name == null) {
	    throw new IllegalArgumentException("Parameter 'name' must not be null.");
	}
	if (array == null) {
	    throw new IllegalArgumentException("Parameter 'array' must not be null.");
	}
	System.out.print(name + "\t" + ".byte ");
	for (int i = 0; i < array.size(); i++) {
	    System.out.print("$" + Integer.toHexString(array.get(i).intValue()));
	    if (i < array.size() - 1) {
		System.out.print(",");
	    }
	}
	System.out.println();
    }

    private void count(int keyInt, TreeMap<Integer, Integer> map) {
	Integer key = new Integer(keyInt);
	Integer value = map.get(key);
	if (value == null) {
	    map.put(key, new Integer(1));
	} else {
	    map.put(key, new Integer(value.intValue() + 1));

	}

    }

    private void test(BufferedImage bi) {
	if (bi == null) {
	    throw new IllegalArgumentException("Parameter 'bi' must not be null.");
	}

	int lumMax = -1;
	int lumMin = 256;
	TreeMap<Integer, Integer> lumMap = new TreeMap<Integer, Integer>();
	List<Integer> lumArray = new ArrayList<Integer>();

	int degMax = -1;
	int degMin = 256;
	TreeMap<Integer, Integer> degMap = new TreeMap<Integer, Integer>();
	List<Integer> degArray = new ArrayList<Integer>();
	List<Integer> spiralArray = new ArrayList<Integer>();

	double ax = 1.0;
	double ay = 1.0;
	double norm = Math.sqrt(ax * ax + ay * ay);

	for (int y = 0; y < YSIZE; y++) {
	    double py = ((2.0f * y / (YSIZE * 1.0)) - 1.0f) * ay;
	    for (int x = 0; x < XSIZE; x++) {
		double px = ((2.0f * x / (XSIZE * 1.0)) - 1.0f) * ax;

		double value = (Math.sqrt(px * px + py * py) / norm);
		// System.out
		// .println("px=" + px + " py=" + py + " value=" + value);
		int lum = ((int) (value * 255));

		lumArray.add(new Integer(lum));
		if (lum > lumMax) {
		    lumMax = lum;
		}
		if (lum < lumMin) {
		    lumMin = lum;
		}
		count(lum, lumMap);

		value = Math.atan2(px, -py);
		int deg = ((int) (value / Math.PI * 128.f));
		deg &= 0xff;

		degArray.add(new Integer(deg));

		// deg = deg / 32;
		if (deg > degMax) {
		    degMax = deg;
		}
		if (deg < degMin) {
		    degMin = deg;
		}
		count(deg, degMap);

		int circle = (deg) / 2;
		int spiral = (deg+lum) / 2;
		spiralArray.add(new Integer(circle));
		spiralArray.add(new Integer(spiral));

		int col1 = 0x010101 * lum;
		int col2 = 0x010101 * deg;
		int col = 0x010101 * spiral;
		bi.setRGB(x, y, col * 4);

	    }
	}
	System.out.println("lumMin=" + lumMin + " lumMax=" + lumMax + " totalRecordCount=" + lumMap.size());
	System.out.println(lumMap.toString());
	System.out.println("degMin=" + degMin + " degMax=" + degMax + " totalRecordCount=" + degMap.size());
	System.out.println(degMap.toString());

	printArray("lumtab", lumArray);
	printArray("degtab", degArray);
	printArray("spiralArray", spiralArray);

	// for (int i = 0; i < 128; i++) {
	// int x = i;
	// if ((i & 0x8) != 0) {
	// x = x ^ 0x7;
	// }
	// x = x << 1;
	// System.out.print("$" + Integer.toHexString(x) + ",");
	// }
    }
}
